﻿Imports System.Data.SqlClient
Public Class frmStockRequest
    Dim gridCount As Integer
    Dim itemId As String
    Dim count As Integer
    Dim itemCode(500), catCode(500), purchaseNo(500) As String
    Dim stockItemDs, stockReqDs As New DataSet
    Dim stockItemDa, stockReqDa As SqlDataAdapter
    Dim result As MsgBoxResult
    Private Sub frmStockRequest_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Db_Connection()
            txtRequestBy.Text = LGNUSERNAME
            LoadItemCategory()
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadItemCode()
        Try
            'LOAD Company Name
            stockItemDs.Reset()
            sql = " SELECT ITM_ITEMCODE, ITM_ITEMDESC FROM ITEMS WHERE ITM_CATID = '" & catCode(cmbItemCategory.SelectedIndex) & "' AND IS_DELETE = 0 "
            stockItemDa = New SqlDataAdapter(sql, Mycn)
            stockItemDa.Fill(stockItemDs, DBNAME)
            cmbItemName.Items.Clear()
            cmbItemCode.Items.Clear()

            Dim rowCount = stockItemDs.Tables(DBNAME).Rows.Count
            For i = 0 To rowCount - 1
                itemCode(i) = stockItemDs.Tables(DBNAME).Rows(i).Item(0)
                cmbItemCode.Items.Add(stockItemDs.Tables(DBNAME).Rows(i).Item(0))
                cmbItemName.Items.Add(stockItemDs.Tables(DBNAME).Rows(i).Item(1))
            Next

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadItemCategory()
        Try
            'LOAD Company Name
            stockItemDs.Reset()
            sql = " SELECT CAT_CATEGORYID, CAT_CATEGORYNAME FROM ITEM_CATEGORY WHERE IS_DELETE = 0 "
            stockItemDa = New SqlDataAdapter(sql, Mycn)
            stockItemDa.Fill(stockItemDs, DBNAME)
            Dim rowCount = stockItemDs.Tables(DBNAME).Rows.Count
            For i = 0 To rowCount - 1
                catCode(i) = stockItemDs.Tables(DBNAME).Rows(i).Item(0)
                cmbItemCategory.Items.Add(stockItemDs.Tables(DBNAME).Rows(i).Item(1))
            Next

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub cmbItemCategory_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbItemCategory.SelectedIndexChanged
        LoadItemCode()
    End Sub

    Private Sub btnAdd_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAdd.Click
        bindGrindList()
        ClearField()
    End Sub

    Private Sub bindGrindList()

        Try
            If cmbItemCategory.Text <> "" And cmbItemName.Text <> "" And txtItemQuantity.Text <> "" Then

                dgvPurchase.Rows.Add()
                dgvPurchase.Item(0, gridCount).Value = gridCount + 1
                dgvPurchase.Item(1, gridCount).Value = cmbItemCategory.Text
                dgvPurchase.Item(2, gridCount).Value = cmbItemName.Text
                dgvPurchase.Item(3, gridCount).Value = cmbItemCode.Text
                dgvPurchase.Item(4, gridCount).Value = txtPartNo.Text
                dgvPurchase.Item(5, gridCount).Value = txtItemQuantity.Text
                dgvPurchase.Item(6, gridCount).Value = txtQtyType.Text
                dgvPurchase.Item(7, gridCount).Value = txtRemark.Text
                gridCount += 1

            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

    Private Sub btnComplete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnComplete.Click
        LoadPurchaseOrder()
        ClearField()
        btnComplete.Enabled = False
        btnPrint.Enabled = True
    End Sub

    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        dgvPurchase.Rows.RemoveAt(dgvPurchase.CurrentRow.Index)
        gridCount -= 1
    End Sub
    Private Sub LoadPurchaseOrder()
        Try
            frmPendingApproval.txtStocCount.Text = dgvPurchase.Rows.Count
            If dgvPurchase.Rows.Count <> 0 Then

                ' INSERT THE VALUES INTO PURCHASE ITEMS TABLES
                stockReqDs.Reset()
                sql = " SELECT  SRQ_DATE, SRQ_ITEMCAT, SRQ_ITEMCODE, SRQ_QTY, SRQ_ISSUEDQTY, SRQ_REMARK, SRQ_REQUESTBY, SRQ_APRVBY, SRQ_ORDERBY, SRQ_STATUS, SRQ_ITEMBEFORE, CREATED_DATE FROM STOCK_REQUEST "
                stockReqDa = New SqlDataAdapter(sql, Mycn)
                stockReqDa.Fill(stockReqDs, DBNAME)

                For i = 0 To dgvPurchase.Rows.Count - 1

                    Dim dsNewRow As DataRow
                    Dim cb1 As New SqlCommandBuilder(stockReqDa)
                    dsNewRow = stockReqDs.Tables(DBNAME).NewRow()
                    dsNewRow.Item("SRQ_DATE") = Now.ToString("MM/dd/yyyy")
                    dsNewRow.Item("SRQ_ITEMCAT") = ""
                    dsNewRow.Item("SRQ_ITEMCODE") = dgvPurchase.Rows.Item(i).Cells(3).Value
                    dsNewRow.Item("SRQ_QTY") = dgvPurchase.Rows.Item(i).Cells(5).Value
                    dsNewRow.Item("SRQ_REMARK") = dgvPurchase.Rows.Item(i).Cells(7).Value
                    dsNewRow.Item("SRQ_ISSUEDQTY") = "0"
                    dsNewRow.Item("SRQ_REQUESTBY") = LGNID
                    dsNewRow.Item("SRQ_APRVBY") = ""
                    dsNewRow.Item("SRQ_ORDERBY") = ""
                    dsNewRow.Item("SRQ_STATUS") = 0
                    dsNewRow.Item("SRQ_ITEMBEFORE") = dtpPurchaseBefore.Value.ToString("MM/dd/yyyy")
                    dsNewRow.Item("CREATED_DATE") = Now.ToString("MM/dd/yyyy")

                    stockReqDs.Tables(DBNAME).Rows.Add(dsNewRow)
                    stockReqDa.Update(stockReqDs, DBNAME)

                Next

                result = MsgBox("New Purchase Request Added. You want to Print the Request", MsgBoxStyle.YesNo)
                If result = MsgBoxResult.Yes Then
                    FACTORYMANAGEMENT.StatusStrip.Refresh()
                    FACTORYMANAGEMENT.ToolStripStatusLabel.Text = "Loading"
                    FACTORYMANAGEMENT.ToolStripProgressBar1.Visible = True
                    FACTORYMANAGEMENT.tmrEnable.Start()
                    FACTORYMANAGEMENT.ToolStripProgressBar1.Increment(-3)
                    frmPendingApproval.Show()
                    FACTORYMANAGEMENT.ToolStripProgressBar1.Visible = False
                    FACTORYMANAGEMENT.ToolStripStatusLabel.Text = "Ready"
                    Me.Close()
                End If
            Else

                MsgBox("No Stock request added.")

            End If
            ClearField()
        Catch ex As Exception

            MsgBox(ex.Message)

        End Try
    End Sub

    Private Sub ClearField()
        cmbItemCategory.Text = ""
        cmbItemName.Text = ""
        cmbItemCode.Text = ""
        txtQtyType.Text = ""
        txtItemQuantity.Text = ""
        cmbItemCode.Items.Clear()
        cmbItemName.Items.Clear()
        dtpPurchaseBefore.Focus()
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub cmbItemCode_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbItemName.SelectedIndexChanged

        Try
            'LOAD Company Name
            stockItemDs.Reset()
            sql = " SELECT A.ITM_ITEMCODE, A.ITM_PARTNO, B.QTY_TYPE FROM ITEMS AS A LEFT JOIN QTYPE_MASTER AS B ON A.ITM_QTYTYPE=B.QTY_CODE WHERE A. ITM_ITEMCODE= '" & itemCode(cmbItemName.SelectedIndex) & "' AND A.IS_DELETE = 0 "
            stockItemDa = New SqlDataAdapter(sql, Mycn)
            stockItemDa.Fill(stockItemDs, DBNAME)
            Dim rowCount = stockItemDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                txtPartNo.Text = stockItemDs.Tables(DBNAME).Rows(0).Item(1)
                cmbItemCode.Text = stockItemDs.Tables(DBNAME).Rows(0).Item(0)
                txtQtyType.Text = stockItemDs.Tables(DBNAME).Rows(0).Item(2)
            End If

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

    
    Private Sub cmbItemCode_SelectedIndexChanged_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbItemCode.SelectedIndexChanged
        Try
            'LOAD Company Name
            stockItemDs.Reset()
            sql = " SELECT A.ITM_ITEMDESC, A.ITM_PARTNO, B.QTY_TYPE FROM ITEMS AS A LEFT JOIN QTYPE_MASTER AS B ON A.ITM_QTYTYPE=B.QTY_CODE WHERE A. ITM_ITEMCODE= '" & cmbItemCode.Text & "' AND A.IS_DELETE = 0 "
            stockItemDa = New SqlDataAdapter(sql, Mycn)
            stockItemDa.Fill(stockItemDs, DBNAME)
            Dim rowCount = stockItemDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                txtPartNo.Text = stockItemDs.Tables(DBNAME).Rows(0).Item(1)
                cmbItemName.Text = stockItemDs.Tables(DBNAME).Rows(0).Item(0)
                txtQtyType.Text = stockItemDs.Tables(DBNAME).Rows(0).Item(2)
            End If

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub btnPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrint.Click
        FACTORYMANAGEMENT.StatusStrip.Refresh()
        FACTORYMANAGEMENT.ToolStripStatusLabel.Text = "Loading"
        FACTORYMANAGEMENT.ToolStripProgressBar1.Visible = True
        FACTORYMANAGEMENT.tmrEnable.Start()
        FACTORYMANAGEMENT.ToolStripProgressBar1.Increment(-3)
        frmPendingApproval.Show()
        FACTORYMANAGEMENT.ToolStripProgressBar1.Visible = False
        FACTORYMANAGEMENT.ToolStripStatusLabel.Text = "Ready"
        Me.Close()
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        ClearField()
    End Sub
End Class